{********************************************
; File: GSOS.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT GSOS;
INTERFACE
USES TYPES;
CONST


{
    Read/Write enable bit Codes
    for CreateRec/OpenRec access and requestAccess fields
}

readEnableAllowWrite = $0000;
readEnable = $0001;
writeEnable = $0002;
readWriteEnable = $0003;
fileInvisible = $0004;  { Invisible bit }
backupNeeded = $0020;  { backup needed bit: CreateRec/ OpenRec access  field. (Must be 0 in requestAccess field ) }
renameEnable = $0040;  { rename enable bit: CreateRec/ OpenRec access and requestAccess fields }
destroyEnable = $0080;  { destroy enable  bit: CreateRec/ OpenRec access and requestAccess fields }
startPlus = $0000;  { base -> setMark = displacement }
eofMinus = $0001;  { base -> setMark = eof - displacement }
markPlus = $0002;  { base -> setMark = mark + displacement }
markMinus = $0003;  { base -> setMark = mark - displacement }

{ cachePriority Codes }
cacheOff = $0000;  { do not cache blocks invloved in this read }
cacheOn = $0001;  { cache blocks invloved in this read if possible }

{ Error Codes }
badSystemCall = $0001;  { bad system call number }
invalidPcount = $0004;  { invalid parameter count }
gsosActive = $0007;  { GS/OS already active }
{$IFC UNDEFINED devNotFound }  { device not found }
devNotFound = $10;
{$SETC devNotFound := 0}
{$ENDC}
invalidDevNum = $11;  { invalid device number }
drvrBadReq = $20;  { bad request or command }
drvrBadCode = $0021;  { bad control or status code }
drvrBadParm = $0022;  { bad call parameter }
drvrNotOpen = $0023;  { character device not open }
drvrPriorOpen = $0024;  { character device already open }
irqTableFull = $0025;  { interrupt table full }
drvrNoResrc = $0026;  { resources not available }
drvrIOError = $0027;  { I/O error }
drvrNoDevice = $0028;  { device not connected }
drvrBusy = $0029;  { call aborted; driver is busy }
drvrWrtProt = $002B;  { device is write protected }
drvrBadCount = $002C;  { invalid byte count }
drvrBadBlock = $002D;  { invalid block address }
drvrDiskSwitch = $002E;  { disk has been switched }
drvrOffLine = $002F;  { device off line/ no media present }
badPathSyntax = $0040;  { invalid pathname syntax }
invalidRefNum = $0043;  { invalid reference number }
{$IFC UNDEFINED pathNotFound }  { subdirectory does not exist }
pathNotFound = $44;
{$SETC pathNotFound := 0}
{$ENDC}
volNotFound = $0045;  { volume not found }
{$IFC UNDEFINED fileNotFound }  { file not found }
fileNotFound = $0046;
{$SETC fileNotFound := 0}
{$ENDC}
dupPathname = $0047;  { create or rename with existing name }
volumeFull = $0048;  { volume full error }
volDirFull = $0049;  { volume directory full }
badFileFormat = $004A;  { version error (incompatible file format) }
{$IFC UNDEFINED badStoreType }  { unsupported (or incorrect) storage type }
badStoreType = $004B;
{$SETC badStoreType := 0}
{$ENDC}
{$IFC UNDEFINED eofEncountered }  { end-of-file encountered }
eofEncountered = $004C;
{$SETC eofEncountered := 0}
{$ENDC}
outOfRange = $004D;  { position out of range }
invalidAccess = $004E;  { access not allowed }
buffTooSmall = $004F;  { buffer too small }
fileBusy = $0050;  { file is already open }
dirError = $0051;  { directory error }
unknownVol = $0052;  { unknown volume type }
{$IFC UNDEFINED paramRangeErr }  { parameter out of range }
paramRangeErr = $0053;
{$SETC paramRangeErr := 0}
{$ENDC}
outOfMem = $0054;  { out of memory }
dupVolume = $0057;  { duplicate volume name }
notBlockDev = $0058;  { not a block device }
{$IFC UNDEFINED invalidLevel }  { specifield level outside legal range }
invalidLevel = $0059;
{$SETC invalidLevel := 0}
{$ENDC}
damagedBitMap = $005A;  { block number too large }
badPathNames = $005B;  { invalid pathnames for ChangePath }
notSystemFile = $005C;  { not an executable file }
osUnsupported = $005D;  { Operating System not supported }
{$IFC UNDEFINED stackOverflow }  { too many applications on stack }
stackOverflow = $005F;
{$SETC stackOverflow := 0}
{$ENDC}
dataUnavail = $0060;  { Data unavailable }
endOfDir = $0061;  { end of directory has been reached }
invalidClass = $0062;  { invalid FST call class }
resForkNotFound = $0063;  { file does not contain required resource }
invalidFSTID = $0064;  { error - FST ID is invalid }
devNameErr = $0067;  { device exists with same name as replacement name }
resExistsErr = $0070;  { cannot expand file, resource already exists }
resAddErr = $0071;  { cannot add resource fork to this type file }

{ fileSys IDs }
proDOSFSID = $0001;  { ProDOS/SOS  }
dos33FSID = $0002;  { DOS 3.3 }
dos32FSID = $0003;  { DOS 3.2 }
dos31FSID = $0003;  { DOS 3.1 }
appleIIPascalFSID = $0004;  { Apple II Pascal }
mfsFSID = $0005;  { Macintosh (flat file system) }
hfsFSID = $0006;  { Macintosh (hierarchical file system) }
lisaFSID = $0007;  { Lisa file system }
appleCPMFSID = $0008;  { Apple CP/M }
charFSTFSID = $0009;  { Character FST }
msDOSFSID = $000A;  { MS/DOS }
highSierraFSID = $000B;  { High Sierra }
iso9660FSID = $000C;  { ISO 9660 }
appleShareFSID = $000D;  { ISO 9660 }

{ FSTInfo.attributes Codes }
characterFST = $4000;  { character FST }
ucFST = $8000;  { SCM should upper case pathnames before passing them to the FST }

{ QuitRec.flags Codes }
onStack = $8000;  { place state information about quitting program on the quit return stack }
restartable = $4000;  { the quitting program is capable of being restarted from its dormant memory }

{ storageType Codes }
seedling = $0001;  { standard file with seedling structure }
standardFile = $0001;  { standard file type (no resource fork) }
sapling = $0002;  { standard file with sapling structure }
tree = $0003;  { standard file with tree structure }
pascalRegion = $0004;  { UCSD Pascal region on a partitioned disk }
extendedFile = $0005;  { extended file type (with resource fork) }
directoryFile = $000D;  { volume directory or subdirectory file }

{ version Codes }
minorRelNumMask = $00FF;  { minor release number }
majorRelNumMask = $7F00;  { major release number }
finalRelNumMask = $8000;  { final release number }

{ Other Constants }
isFileExtended = $8000;  { GetDirEntryGS }

{ DControl Codes }
resetDevice = $0000;
formatDevice = $0001;
eject = $0002;
setConfigParameters = $0003;
setWaitStatus = $0004;
setFormatOptions = $0005;
assignPartitionOwner = $0006;
armSignal = $0007;
disarmSignal = $0008;
setPartitionMap = $0009;

TYPE
GSString255Hndl = ^GSString255Ptr;
GSString255Ptr = ^GSString255;
GSString255 = RECORD
    length : Integer; { Number of Chars in text field  }
    text : PACKED ARRAY[1..255] OF CHAR;
END;
GSString255HndlPtr = ^GSString255Hndl;

GSString32Hndl = ^GSString32Ptr;
GSString32Ptr = ^GSString32;
GSString32 = RECORD
    length : Integer; { Number of characters in text field }
    text : PACKED ARRAY[1..32] OF CHAR;
END;
ResultBuf255Hndl = ^ResultBuf255Ptr;
ResultBuf255Ptr = ^ResultBuf255;
ResultBuf255 = RECORD
    bufSize : Integer;
    bufString : GSString255;
END;
ResultBuf255HndlPtr = ^ResultBuf255Hndl;

ResultBuf32Hndl = ^ResultBuf32Ptr;
ResultBuf32Ptr = ^ResultBuf32;
ResultBuf32 = RECORD
    bufSize : Integer;
    bufString : GSString32;
END;
ChangePathRecPtrGS = ^ChangePathRecGS;
ChangePathRecGS = RECORD
    pCount : Integer;
    pathname : GSString255Ptr;
    newPathname : GSString255Ptr;
END;
CreateRecPtrGS = ^CreateRecGS;
CreateRecGS = RECORD
    pCount : Integer;
    pathname : GSString255Ptr;
    access : Integer;
    fileType : Integer;
    auxType : Longint;
    storageType : Integer;
    eof : Longint;
    resourceEOF : Longint;
END;
DAccessRecPtrGS = ^DAccessRecGS;
DAccessRecGS = RECORD
    pCount : Integer;
    devNum : Integer;
    code : Integer;
    list : Ptr;
    requestCount : Longint;
    transferCount : Longint;
END;
DevNumRecPtrGS = ^DevNumRecGS;
DevNumRecGS = RECORD
    pCount : Integer;
    devName : GSString32Ptr;
    devNum : Integer;
END;
DInfoRecPtrGS = ^DInfoRecGS;
DInfoRecGS = RECORD
    pCount : Integer; { minimum = 2 }
    devNum : Integer;
    devName : ResultBuf32Ptr;
    characteristics : Integer;
    totalBlocks : Longint;
    slotNum : Integer;
    unitNum : Integer;
    version : Integer;
    deviceID : Integer;
    headLink : Integer;
    forwardLink : Integer;
    extendedDIBPtr : Ptr;
END;
DIORecPtrGS = ^DIORecGS;
DIORecGS = RECORD
    pCount : Integer;
    devNum : Integer;
    buffer : Ptr;
    requestCount : Longint;
    startingBlock : Longint;
    blockSize : Integer;
    transferCount : Longint;
END;
DirEntryRecPtrGS = ^DirEntryRecGS;
DirEntryRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    flags : Integer;
    base : Integer;
    displacement : Integer;
    name : ResultBuf255Ptr;
    entryNum : Integer;
    fileType : Integer;
    eof : Longint;
    blockCount : Longint;
    createDateTime : TimeRec;
    modDateTime : TimeRec;
    access : Integer;
    auxType : Longint;
    fileSysID : Integer;
    optionList : ResultBuf255Ptr;
    resourceEOF : Longint;
    resourceBlocks : Longint;
END;
DRenameRecGSPtr = ^DRenameRecGS;
DRenameRecGS = RECORD
    pCount : Integer;
    devNum : Integer;
    strPtr : GSString32Ptr;
END;
ExpandPathRecPtrGS = ^ExpandPathRecGS;
ExpandPathRecGS = RECORD
    pCount : Integer;
    inputPath : GSString255Ptr;
    outputPath : ResultBuf255Ptr;
    flags : Integer;
END;
FileInfoRecPtrGS = ^FileInfoRecGS;
FileInfoRecGS = RECORD
    pCount : Integer;
    pathname : GSString255Ptr;
    access : Integer;
    fileType : Integer;
    auxType : Longint;
    storageType : Integer; { must be 0 for SetFileInfo }
    createDateTime : TimeRec;
    modDateTime : TimeRec;
    optionList : ResultBuf255Ptr;
    eof : Longint;
    blocksUsed : Longint; { must be 0 for SetFileInfo }
    resourceEOF : Longint; { must be 0 for SetFileInfo }
    resourceBlocks : Longint; { must be 0 for SetFileInfo }
END;
FormatRecPtrGS = ^FormatRecGS;
FormatRecGS = RECORD
    pCount : Integer;
    devName : GSString32Ptr; { device name pointer }
    volName : GSString32Ptr; { volume name pointer }
    fileSysID : Integer; { file system ID }
    reqFileSysID : Integer; { in;  }
END;
FSTInfoRecPtrGS = ^FSTInfoRecGS;
FSTInfoRecGS = RECORD
    pCount : Integer;
    fstNum : Integer;
    fileSysID : Integer;
    fstName : ResultBuf255Ptr;
    version : Integer;
    attributes : Integer;
    blockSize : Integer;
    maxVolSize : Longint;
    maxFileSize : Longint;
END;
InterruptRecPtrGS = ^InterruptRecGS;
InterruptRecGS = RECORD
    pCount : Integer;
    intNum : Integer;
    vrn : Integer; { used only by BindInt }
    intCode : ProcPtr; { used only by BindInt }
END;
IORecPtrGS = ^IORecGS;
IORecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    dataBuffer : Ptr;
    requestCount : Longint;
    transferCount : Longint;
    cachePriority : Integer;
END;
LevelRecPtrGS = ^LevelRecGS;
LevelRecGS = RECORD
    pCount : Integer;
    level : Integer;
END;
NameRecPtrGS = ^NameRecGS;
NameRecGS = RECORD
    pCount : Integer;
    pathname : GSString255Ptr; { full pathname or a filename depending on call }
END;
NotifyProcRecGSPtr = ^NotifyProcRecGS;
NotifyProcRecGS = RECORD
    pCount : Integer;
    procPointer : ProcPtr;
END;
GetNameRecPtrGS = ^GetNameRecGS;
GetNameRecGS = RECORD
    pCount : Integer;
    dataBuffer : ResultBuf255Ptr; { full pathname or a filename depending on call }
END;
NewlineRecPtrGS = ^NewlineRecGS;
NewlineRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    enableMask : Integer;
    numChars : Integer;
    newlineTable : Ptr;
END;
OpenRecPtrGS = ^OpenRecGS;
OpenRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    pathname : GSString255Ptr;
    requestAccess : Integer;
    resourceNumber : Integer; { For extended files: dataFork/resourceFork }
    access : Integer; { Value of file's access attribute }
    fileType : Integer; { Value of file's fileType attribute }
    auxType : Longint;
    storageType : Integer;
    createDateTime : TimeRec;
    modDateTime : TimeRec;
    optionList : ResultBuf255Ptr;
    eof : Longint;
    blocksUsed : Longint;
    resourceEOF : Longint;
    resourceBlocks : Longint;
END;
OSShutDownRecPtrGS = ^OSShutDownRecGS;
OSShutDownRecGS = RECORD
    pCount : Integer;
    shutdownFlag : Integer;
END;
PositionRecPtrGS = ^PositionRecGS;
PositionRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    position : Longint;
END;
EOFRecPtrGS = ^EOFRecGS;
EOFRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    eof : Longint;
END;
PrefixRecPtrGS = ^PrefixRecGS;
PrefixRecGS = RECORD
    pCount : Integer;
    prefixNum : Integer;
    CASE INTEGER OF
         0: (getPrefix : ResultBuf255Ptr;);
         1: (setPrefix : GSString255Ptr;);
END;
QuitRecPtrGS = ^QuitRecGS;
QuitRecGS = RECORD
    pCount : Integer;
    pathname : GSString255Ptr; { pathname of next app to run }
    flags : Integer;
END;
RefnumRecPtrGS = ^RefNumRecGS;
RefNumRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
END;
GetRefNumRecPtrGS = ^GetRefNumRecGS;
GetRefNumRecGS = RECORD
    pCount : Integer;
    pathname : GSString255Ptr;
    refNum : Integer;
    access : Integer;
    resNum : Integer;
    caseSense : Boolean;
    displacement : Integer;
END;
StdRefNumRecGSPtr = ^StdRefNumRecGS;
StdRefNumRecGS = RECORD
    pCount : Integer;
    prefixNum : Integer;
    refNum : Integer;
END;
SessionStatusRecPtrGS = ^SessionStatusRecGS;
SessionStatusRecGS = RECORD
    pCount : Integer; { in: min = 1 }
    status : Integer; { out: }
END;
SetPositionRecPtrGS = ^SetPositionRecGS;
SetPositionRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    base : Integer;
    displacement : Longint;
END;
SysPrefsRecPtrGS = ^SysPrefsRecGS;
SysPrefsRecGS = RECORD
    pCount : Integer;
    preferences : Integer;
END;
VersionRecPtrGS = ^VersionRecGS;
VersionRecGS = RECORD
    pCount : Integer;
    version : Integer;
END;
VolumeRecPtrGS = ^VolumeRecGS;
VolumeRecGS = RECORD
    pCount : Integer;
    devName : GSString32Ptr;
    volName : ResultBuf255Ptr;
    totalBlocks : Longint;
    freeBlocks : Longint;
    fileSysID : Integer;
    blockSize : Integer;
END;
RefInfoRecGSPtr = ^RefInfoRecGS;
RefInfoRecGS = RECORD
    pCount : Integer;
    refNum : Integer;
    access : Integer;
    pathname : ResultBuf255Ptr;
END;
FileRecGS = RECORD
  CASE Integer OF
    0: (deRec : DirEntryRecGS);
    1: (ioRec : IORecGS);
    2: (nlRec : NewlineRecGS);
    3: (opRec : OpenRecGS);
    4: (poRec : PositionRecGS);
    5: (eoRec : EOFRecGS);
    6: (rnRec : RefNumRecGS);
    7: (spRec : SetPositionRecGS);
  END;

PROCEDURE AddNotifyProcGS (VAR pblockPtr: NotifyProcRecGSPtr);
INLINE $2034F4,$E100B022,$8F,'_toolErr';

PROCEDURE BeginSessionGS (VAR pblockPtr: SessionStatusRecGS);
INLINE $201DF4,$E100B022,$8F,'_toolErr';

PROCEDURE BindIntGS (VAR pblockPtr: InterruptRecGS);
INLINE $2031F4,$E100B022,$8F,'_toolErr';

PROCEDURE ChangePathGS (VAR pblockPtr: ChangePathRecGS);
INLINE $2004F4,$E100B022,$8F,'_toolErr';

PROCEDURE ClearBackupBitGS (VAR pblockPtr: NameRecGS);
INLINE $200BF4,$E100B022,$8F,'_toolErr';

PROCEDURE CloseGS (VAR pblockPtr: RefNumRecGS);
INLINE $2014F4,$E100B022,$8F,'_toolErr';

PROCEDURE CreateGS (VAR pblockPtr: CreateRecGS);
INLINE $2001F4,$E100B022,$8F,'_toolErr';

PROCEDURE DControlGS (VAR pblockPtr: DAccessRecGS);
INLINE $202EF4,$E100B022,$8F,'_toolErr';

PROCEDURE DelNotifyProcGS (VAR pblockPtr: NotifyProcRecGSPtr);
INLINE $2035F4,$E100B022,$8F,'_toolErr';

PROCEDURE DestroyGS (VAR pblockPtr: NameRecGS);
INLINE $2002F4,$E100B022,$8F,'_toolErr';

PROCEDURE DInfoGS (VAR pblockPtr: DInfoRecGS);
INLINE $202CF4,$E100B022,$8F,'_toolErr';

PROCEDURE DReadGS (VAR pblockPtr: DIORecGS);
INLINE $202FF4,$E100B022,$8F,'_toolErr';

PROCEDURE DRenameGS (VAR pblockPtr: DRenameRecGS);
INLINE $2036F4,$E100B022,$8F,'_toolErr';

PROCEDURE DStatusGS (VAR pblockPtr: DAccessRecGS);
INLINE $202DF4,$E100B022,$8F,'_toolErr';

PROCEDURE DWriteGS (VAR pblockPtr: DIORecGS);
INLINE $2030F4,$E100B022,$8F,'_toolErr';

PROCEDURE EndSessionGS (VAR pblockPtr: SessionStatusRecGS);
INLINE $201EF4,$E100B022,$8F,'_toolErr';

PROCEDURE EraseDiskGS (VAR pblockPtr: FormatRecGS);
INLINE $2025F4,$E100B022,$8F,'_toolErr';

PROCEDURE ExpandPathGS (VAR pblockPtr: ExpandPathRecGS);
INLINE $200EF4,$E100B022,$8F,'_toolErr';

PROCEDURE FlushGS (VAR pblockPtr: RefNumRecGS);
INLINE $2015F4,$E100B022,$8F,'_toolErr';

PROCEDURE FormatGS (VAR pblockPtr: FormatRecGS);
INLINE $2024F4,$E100B022,$8F,'_toolErr';

PROCEDURE FSTSpecific (pBlockPtr: Ptr);
INLINE $2033F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetBootVolGS (VAR pblockPtr: GetNameRecGS);
INLINE $2028F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetDevNumberGS (VAR pblockPtr: DevNumRecGS);
INLINE $2020F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetDirEntryGS (VAR pblockPtr: DirEntryRecGS);
INLINE $201CF4,$E100B022,$8F,'_toolErr';

PROCEDURE GetEOFGS (VAR pblockPtr: EOFRecGS);
INLINE $2019F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetFileInfoGS (VAR pblockPtr: FileInfoRecGS);
INLINE $2006F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetFSTInfoGS (VAR pblockPtr: FSTInfoRecGS);
INLINE $202BF4,$E100B022,$8F,'_toolErr';

PROCEDURE GetLevelGS (VAR pblockPtr: LevelRecGS);
INLINE $201BF4,$E100B022,$8F,'_toolErr';

PROCEDURE GetMarkGS (VAR pblockPtr: PositionRecGS);
INLINE $2017F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetNameGS (VAR pblockPtr: GetNameRecGS);
INLINE $2027F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetPrefixGS (VAR pblockPtr: PrefixRecGS);
INLINE $200AF4,$E100B022,$8F,'_toolErr';

PROCEDURE GetRefInfoGS (VAR pblockPtr: RefInfoRecGS);
INLINE $2039F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetRefNumGS (VAR pblockPtr: GetRefNumRecGS);
INLINE $2038F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetStdRefNumGS (VAR pblockPtr: StdRefNumRecGS);
INLINE $2037F4,$E100B022,$8F,'_toolErr';

PROCEDURE GetSysPrefsGS (VAR pblockPtr: SysPrefsRecGS);
INLINE $200FF4,$E100B022,$8F,'_toolErr';

PROCEDURE GetVersionGS (VAR pblockPtr: VersionRecGS);
INLINE $202AF4,$E100B022,$8F,'_toolErr';

PROCEDURE NewlineGS (VAR pblockPtr: NewlineRecGS);
INLINE $2011F4,$E100B022,$8F,'_toolErr';

PROCEDURE NullGS (VAR pblockPtr: IntPtr);
INLINE $200DF4,$E100B022,$8F,'_toolErr';

PROCEDURE OpenGS (VAR pblockPtr: OpenRecGS);
INLINE $2010F4,$E100B022,$8F,'_toolErr';

PROCEDURE OSShutDownGS (VAR pblockPtr: OSShutDownRecGS);
INLINE $2003F4,$E100B022,$8F,'_toolErr';

PROCEDURE QuitGS (VAR pblockPtr: QuitRecGS);
INLINE $2029F4,$E100B022,$8F,'_toolErr';

PROCEDURE ReadGS (VAR pblockPtr: IORecGS);
INLINE $2012F4,$E100B022,$8F,'_toolErr';

PROCEDURE ResetCacheGS (VAR pblockPtr: IntPtr);
INLINE $2026F4,$E100B022,$8F,'_toolErr';

PROCEDURE SessionStatusGS (VAR pblockPtr: SessionStatusRecGS);
INLINE $201FF4,$E100B022,$8F,'_toolErr';

PROCEDURE SetEOFGS (VAR pblockPtr: SetPositionRecGS);
INLINE $2018F4,$E100B022,$8F,'_toolErr';

PROCEDURE SetFileInfoGS (VAR pblockPtr: FileInfoRecGS);
INLINE $2005F4,$E100B022,$8F,'_toolErr';

PROCEDURE SetLevelGS (VAR pblockPtr: LevelRecGS);
INLINE $201AF4,$E100B022,$8F,'_toolErr';

PROCEDURE SetMarkGS (VAR pblockPtr: SetPositionRecGS);
INLINE $2016F4,$E100B022,$8F,'_toolErr';

PROCEDURE SetPrefixGS (VAR pblockPtr: PrefixRecGS);
INLINE $2009F4,$E100B022,$8F,'_toolErr';

PROCEDURE SetSysPrefsGS (VAR pblockPtr: SysPrefsRecGS);
INLINE $200CF4,$E100B022,$8F,'_toolErr';

PROCEDURE UnbindIntGS (VAR pblockPtr: InterruptRecGS);
INLINE $2032F4,$E100B022,$8F,'_toolErr';

PROCEDURE VolumeGS (VAR pblockPtr: VolumeRecGS);
INLINE $2008F4,$E100B022,$8F,'_toolErr';

PROCEDURE WriteGS (VAR pblockPtr: IORecGS);
INLINE $2013F4,$E100B022,$8F,'_toolErr';

IMPLEMENTATION
END.
